# نظام إدارة روضة الأطفال

نظام شامل لإدارة روضة الأطفال باستخدام Python و Flask و SQLite مع واجهة عربية متجاوبة.

## المميزات

### 🔷 الواجهة الرئيسية
- صفحة ترحيبية تعرض معلومات النظام
- روابط للدخول إلى البوابات الثلاث
- تصميم متجاوب يعمل على جميع الأجهزة

### 🧩 بوابة الإدارة
- **إدارة الأطفال**: تسجيل وتحديث بيانات الأطفال (الاسم، العمر، القسم، الولي، الحالة الصحية)
- **الحضور والغياب**: تسجيل ومتابعة حضور الأطفال يومياً
- **إدارة الأقسام**: تنظيم الأطفال في أقسام مختلفة
- **الرسوم والمدفوعات**: متابعة وإدارة المدفوعات المالية
- **الأنشطة والبرامج**: إضافة وجدولة الأنشطة اليومية والأسبوعية
- **التقارير والإحصائيات**: عرض تقارير شاملة عن الحضور والأنشطة والوضع المالي
- **إدارة المستخدمين**: إضافة وإدارة حسابات المعلمين وأولياء الأمور

### 🟢 بوابة المعلمين
- **قائمة الأطفال**: عرض أطفال القسم المخصص للمعلم
- **تسجيل الحضور**: تسجيل حضور وغياب الأطفال يومياً
- **تقارير الأطفال**: إضافة ملاحظات وتقارير عن كل طفل
- **الأنشطة المجدولة**: الاطلاع على البرامج والأنشطة المخططة
- **التواصل**: إمكانية التواصل مع الإدارة

### 🔹 بوابة أولياء الأمور
- **بيانات الطفل**: عرض المعلومات الأساسية للطفل
- **سجل الحضور**: متابعة حضور وغياب الطفل
- **الأنشطة والبرامج**: معرفة الأنشطة المجدولة للطفل
- **الوضع المالي**: عرض الرسوم المدفوعة والمتبقية
- **الرسائل**: إرسال واستقبال رسائل مع الإدارة

## قاعدة البيانات

النظام يستخدم قاعدة بيانات SQLite مع الجداول التالية:

- **users**: المستخدمين (الإدارة، المعلمين، أولياء الأمور)
- **children**: بيانات الأطفال
- **attendance**: سجلات الحضور والغياب
- **payments**: المدفوعات والرسوم
- **programs**: الأنشطة والبرامج
- **messages**: الرسائل بين المستخدمين
- **teachers**: بيانات المعلمين وأقسامهم

## التقنيات المستخدمة

- **Backend**: Python 3.x + Flask
- **Database**: SQLite
- **Frontend**: HTML5, CSS3, Bootstrap 5 (RTL)
- **Icons**: Font Awesome
- **Fonts**: Google Fonts (Cairo)

## متطلبات التشغيل

- Python 3.7 أو أحدث
- pip (مدير حزم Python)

## طريقة التثبيت والتشغيل

### 1. تثبيت Python
تأكد من تثبيت Python 3.7 أو أحدث على جهازك.

### 2. تثبيت المتطلبات
```bash
pip install -r requirements.txt
```

### 3. تشغيل التطبيق
```bash
python app.py
```

### 4. فتح التطبيق
افتح المتصفح وانتقل إلى: `http://localhost:5000`

## الحسابات الافتراضية

### حساب الإدارة
- **اسم المستخدم**: admin
- **كلمة المرور**: admin123

### حسابات تجريبية (يمكن إنشاؤها من لوحة الإدارة)
- **معلم**: teacher1 / teacher123
- **ولي أمر**: parent1 / parent123

## هيكل المشروع

```
kidro/
├── app.py                 # الملف الرئيسي للتطبيق
├── requirements.txt       # متطلبات Python
├── README.md             # دليل الاستخدام
├── db/                   # مجلد قاعدة البيانات
│   └── kidro.db         # ملف قاعدة البيانات
├── templates/           # قوالب HTML
│   ├── base.html        # القالب الأساسي
│   ├── index.html       # الصفحة الرئيسية
│   ├── login.html       # صفحة تسجيل الدخول
│   ├── admin/           # قوالب بوابة الإدارة
│   ├── teacher/         # قوالب بوابة المعلمين
│   └── parent/          # قوالب بوابة أولياء الأمور
└── static/              # الملفات الثابتة (CSS, JS, Images)
```

## الميزات الإضافية

- **الأمان**: نظام تسجيل دخول آمن مع تشفير كلمات المرور
- **التجاوب**: واجهة متجاوبة تعمل على الهاتف والحاسوب
- **البحث والفلترة**: إمكانية البحث والفلترة في الجداول
- **اللغة العربية**: واجهة مصممة خصيصاً للغة العربية
- **سهولة الاستخدام**: تصميم بديهي وسهل الاستخدام

## الدعم والمساعدة

للحصول على المساعدة أو الإبلاغ عن مشاكل:
- تواصل مع فريق التطوير
- راجع التوثيق المرفق
- تحقق من سجلات الأخطاء في وحدة التحكم

## الترخيص

هذا المشروع مفتوح المصدر ومتاح للاستخدام التعليمي والتجاري.

---

**ملاحظة**: هذا النظام مصمم خصيصاً لإدارة رياض الأطفال ويمكن تخصيصه حسب احتياجات كل روضة.
